Rem BreakFrame.vbs
Rem An InDesign VBScript
Rem
Rem Removes the selected text frame (or text frames) from the
Rem story containing the text frame and removes the text contained
Rem by the text frame from the story.
Rem
Rem If you want to split *all* of the text fames in the story, use the
Rem SplitStory.vbs script.
Rem
Rem For more on InDesign/InCopy scripting see the documentation included in the Scripting SDK 
Rem available at http://www.adobe.com/devnet/indesign/sdk.html
Rem Or visit the InDesign Scripting User to User forum at http://www.adobeforums.com.
Rem
main
Function main()
	ReDim myObjectList(0)
	Set myInDesign = CreateObject("InDesign.Application.2021")
	Rem Set the user interaction level to allow the display of dialog boxes and alerts.
	myInDesign.ScriptPreferences.UserInteractionLevel = idUserInteractionLevels.idInteractWithAll
	Rem Script does nothing if no documents are open or if no objects are selected.
	If myInDesign.Documents.Count <> 0 Then
	    If myInDesign.Selection.Count <> 0 Then
	        Rem Process the objects in the selection to create a list of
	        Rem qualifying objects (text frames).
	        For myCounter = 1 To myInDesign.Selection.Count
	            Select Case TypeName(myInDesign.Selection.Item(myCounter))
	                Case "TextFrame":
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter)
	                Case "InsertionPoint", "Character", "Word", "TextStyleRange", "Line", "Paragraph", "TextColumn", "Text":
	                    If Not (IsEmpty(myObjectList(0))) Then
	                        ReDim Preserve myObjectList(UBound(myObjectList) + 1)
	                    End If
	                    Set myObjectList(UBound(myObjectList)) = myInDesign.Selection.Item(myCounter).ParentTextFrames.Item(1)
	            End Select
	        Next
	        Rem If the object list is not empty, pass it on to the function
	        Rem that does the real work.
	        If Not (IsEmpty(myObjectList(0))) Then
	            myBreakFrames myObjectList
	        End If
	    End If
	End If
End function
Function myBreakFrames(myObjectList)
    For myCounter = UBound(myObjectList) To 0 Step -1
        myBreakOutFrame myObjectList(myCounter)
    Next
End Function
Function myBreakOutFrame(myTextFrame)
    myProcessFrame = vbYes
    If (TypeName(myTextFrame.NextTextFrame) <> "Nothing") Or (TypeName(myTextFrame.PreviousTextFrame) <> "Nothing") Then
        If myTextFrame.ParentStory.Tables.Count <> 0 Then
            myProcessFrame = MsgBox("This story contains tables. If the text frame you are trying to remove from the story contains a table, the results might not be what you expect. Do you want to continue?", vbYesNo)
        End If
        If myProcessFrame = vbYes Then
            Set myNewFrame = myTextFrame.Duplicate
            If myTextFrame.Contents <> "" Then
                myTextFrame.Texts.Item(1).Delete
            End If
            myTextFrame.Delete
        End If
    End If
End Function

'' SIG '' Begin signature block
'' SIG '' MIIeVAYJKoZIhvcNAQcCoIIeRTCCHkECAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' exJ4+UDk7fODK5A8P9r5I0+rPD62OT2w4uletzzlB7Cg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQB3XcWt35KITbGdVVTAfs
'' SIG '' STANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTE5
'' SIG '' MDEzMTAwMDAwMFoXDTIxMDIwMzEyMDAwMFowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAIiKXEE3
'' SIG '' 5FJAWPRPxAu4g1GRRZmzrPW3SZL40s8opqkFWksx2dBE
'' SIG '' yP6+N6visRXUyDy+I979oO9tEtHBeYKx1XHy4NOLPl3u
'' SIG '' Lr8rWv5E3hrNw+QRwJvsMJLzBTS44811Rym8ddkt8lpj
'' SIG '' dG1PmC2aZQ73miR88+46IaZDtuabo3corXvrG0wmLFZb
'' SIG '' SrB80HAigwQiwHgh33cI2pPIYA2VdmEv5V3iI+AuYybL
'' SIG '' BPJ32YPqdvcoR3Ml/oYFcFlUb1sliNdngwqEeUTKBWVu
'' SIG '' OTeuRo2gOioizpUxR3cce25eoH8wONWUozkjPwcUEY8I
'' SIG '' RCePRf21c4kjjLGFSmpwEVQVQJcCAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBSVoz2+cIajBhNjiGb0VJBYxDX9vzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEADtCQA7go0Xu2UKN6dFPe
'' SIG '' YJbS/OXx3n3IP0K9CGPDozeGV62MvbCp+DuptFa44FYR
'' SIG '' ZuljRXMxCjsjJmkJLD9Hhuik+a23iSwfOAnWK6AY/VoD
'' SIG '' ZatWvGG6mZzMRs/s5Whztt8IRxLMrLbA+ulDkDKTlqqf
'' SIG '' BWN8xAM23VX2IMmPYFXMf1TgyT3rCr2oontG6eWT0VYa
'' SIG '' j8DrYJuWtoNQaHIxSg3lGWyvqi1RwJc7GjVwJObnRCTH
'' SIG '' Faqmfxwry/5jEDjPNNUyDiMWIr2xxCbe5pu759mb9Hjl
'' SIG '' rSakmU9AhIxEURqKA3wmnF9Sw+OnazRGp4bvfkCeWDtK
'' SIG '' LdN4JKj5eh21hDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCERgwghEUAgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAd13Frd+SiE2xnVVUwH7Ekw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIKHbpsXaBvhS
'' SIG '' fEB0dbL3+KV7MdE8KibAVnGrqJ0Ja9XXMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAPSZu7cdH
'' SIG '' mvGL/64BOsQkdP2M2r9nn69p7JwQGLmhJkcyvS6Y5xmW
'' SIG '' 7j2csY2uhxUB4ViKe+6x7EQbWKRuieazgTWpA5tHZ3cY
'' SIG '' DuZIl6Gd+pfAlnE9lpTYTlS7aeL+LisCVKH2AvGAuGi7
'' SIG '' wRm4VdNQ6VohEh7vMndQmVh5fNcqlAWKDJJRnixFHTzu
'' SIG '' f44xJdz9lonw6SOuCEKiTQYV4voadDc22Mm0GMBdzl+x
'' SIG '' fX3kxh3eU3nlDQjv4dHictOrGto9TDp0wCIV2ulmwoy4
'' SIG '' /j8opvqwzJwkC0J63llSsnDvAcNbmsMa/NkMiFhOhcIo
'' SIG '' L29n00ely1ktle6CeyX1C49U/aGCDskwgg7FBgorBgEE
'' SIG '' AYI3AwMBMYIOtTCCDrEGCSqGSIb3DQEHAqCCDqIwgg6e
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAweAYLKoZIhvcNAQkQ
'' SIG '' AQSgaQRnMGUCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCDGhqqEinAOf+dHracKeVxcOZiWMFzhupyx
'' SIG '' k6IsKx6K+QIRANLtYxxJuGXKc+jcmZ5pMjgYDzIwMjAx
'' SIG '' MDA0MDAyMjMyWqCCC7swggaCMIIFaqADAgECAhAEzT+F
'' SIG '' aK52xhuw/nFgzKdtMA0GCSqGSIb3DQEBCwUAMHIxCzAJ
'' SIG '' BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
'' SIG '' GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xMTAvBgNV
'' SIG '' BAMTKERpZ2lDZXJ0IFNIQTIgQXNzdXJlZCBJRCBUaW1l
'' SIG '' c3RhbXBpbmcgQ0EwHhcNMTkxMDAxMDAwMDAwWhcNMzAx
'' SIG '' MDE3MDAwMDAwWjBMMQswCQYDVQQGEwJVUzEXMBUGA1UE
'' SIG '' ChMORGlnaUNlcnQsIEluYy4xJDAiBgNVBAMTG1RJTUVT
'' SIG '' VEFNUC1TSEEyNTYtMjAxOS0xMC0xNTCCASIwDQYJKoZI
'' SIG '' hvcNAQEBBQADggEPADCCAQoCggEBAOlkNZz6qZhlZBvk
'' SIG '' F9y4KTbMZwlYhU0w4Mn/5Ts8EShQrwcx4l0JGML2iYxp
'' SIG '' CAQj4HctnRXluOihao7/1K7Sehbv+EG1HTl1wc8vp6xF
'' SIG '' fpRtrAMBmTxiPn56/UWXMbT6t9lCPqdVm99aT1gCqDJp
'' SIG '' IhO+i4Itxpira5u0yfJlEQx0DbLwCJZ0xOiySKKhFKX4
'' SIG '' +uGJcEQ7je/7pPTDub0ULOsMKCclgKsQSxYSYAtpIoxO
'' SIG '' zcbVsmVZIeB8LBKNcA6Pisrg09ezOXdQ0EIsLnrOnGd6
'' SIG '' OHdUQP9PlQQg1OvIzocUCP4dgN3Q5yt46r8fcMbuQhZT
'' SIG '' NkWbUxlJYp16ApuVFKMCAwEAAaOCAzgwggM0MA4GA1Ud
'' SIG '' DwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB
'' SIG '' /wQMMAoGCCsGAQUFBwMIMIIBvwYDVR0gBIIBtjCCAbIw
'' SIG '' ggGhBglghkgBhv1sBwEwggGSMCgGCCsGAQUFBwIBFhxo
'' SIG '' dHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMIIBZAYI
'' SIG '' KwYBBQUHAgIwggFWHoIBUgBBAG4AeQAgAHUAcwBlACAA
'' SIG '' bwBmACAAdABoAGkAcwAgAEMAZQByAHQAaQBmAGkAYwBh
'' SIG '' AHQAZQAgAGMAbwBuAHMAdABpAHQAdQB0AGUAcwAgAGEA
'' SIG '' YwBjAGUAcAB0AGEAbgBjAGUAIABvAGYAIAB0AGgAZQAg
'' SIG '' AEQAaQBnAGkAQwBlAHIAdAAgAEMAUAAvAEMAUABTACAA
'' SIG '' YQBuAGQAIAB0AGgAZQAgAFIAZQBsAHkAaQBuAGcAIABQ
'' SIG '' AGEAcgB0AHkAIABBAGcAcgBlAGUAbQBlAG4AdAAgAHcA
'' SIG '' aABpAGMAaAAgAGwAaQBtAGkAdAAgAGwAaQBhAGIAaQBs
'' SIG '' AGkAdAB5ACAAYQBuAGQAIABhAHIAZQAgAGkAbgBjAG8A
'' SIG '' cgBwAG8AcgBhAHQAZQBkACAAaABlAHIAZQBpAG4AIABi
'' SIG '' AHkAIAByAGUAZgBlAHIAZQBuAGMAZQAuMAsGCWCGSAGG
'' SIG '' /WwDFTAfBgNVHSMEGDAWgBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAdBgNVHQ4EFgQUVlMPwcYHp03X2G5XcoBQTOTs
'' SIG '' nsEwcQYDVR0fBGowaDAyoDCgLoYsaHR0cDovL2NybDMu
'' SIG '' ZGlnaWNlcnQuY29tL3NoYTItYXNzdXJlZC10cy5jcmww
'' SIG '' MqAwoC6GLGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9z
'' SIG '' aGEyLWFzc3VyZWQtdHMuY3JsMIGFBggrBgEFBQcBAQR5
'' SIG '' MHcwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBPBggrBgEFBQcwAoZDaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0U0hBMkFzc3Vy
'' SIG '' ZWRJRFRpbWVzdGFtcGluZ0NBLmNydDANBgkqhkiG9w0B
'' SIG '' AQsFAAOCAQEALoOhRAVKBOO5MlL62YHwGrv4CY0juT3Y
'' SIG '' kqHmRhxKL256PGNuNxejGr9YI7JDnJSDTjkJsCzox+Hi
'' SIG '' zO3LeWvO3iMBR+2VVIHggHsSsa8Chqk6c2r++J/BjdEh
'' SIG '' jOQpgsOKC2AAAp0fR8SftApoU39aEKb4Iub4U5IxX9iC
'' SIG '' gy1tE0Kug8EQTqQk9Eec3g8icndcf0/pOZgrV5JE1+9u
'' SIG '' k9lDxwQzY1E3Vp5HBBHDo1hUIdjijlbXST9X/AqfI157
'' SIG '' 9JSN3Z0au996KqbSRaZVDI/2TIryls+JRtwxspGQo18z
'' SIG '' MGBV9fxrMKyh7eRHTjOeZ2ootU3C7VuXgvjLqQhsUwm0
'' SIG '' 9zCCBTEwggQZoAMCAQICEAqhJdbWMht+QeQF2jaXwhUw
'' SIG '' DQYJKoZIhvcNAQELBQAwZTELMAkGA1UEBhMCVVMxFTAT
'' SIG '' BgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3
'' SIG '' LmRpZ2ljZXJ0LmNvbTEkMCIGA1UEAxMbRGlnaUNlcnQg
'' SIG '' QXNzdXJlZCBJRCBSb290IENBMB4XDTE2MDEwNzEyMDAw
'' SIG '' MFoXDTMxMDEwNzEyMDAwMFowcjELMAkGA1UEBhMCVVMx
'' SIG '' FTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQ
'' SIG '' d3d3LmRpZ2ljZXJ0LmNvbTExMC8GA1UEAxMoRGlnaUNl
'' SIG '' cnQgU0hBMiBBc3N1cmVkIElEIFRpbWVzdGFtcGluZyBD
'' SIG '' QTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEB
'' SIG '' AL3QMu5LzY9/3am6gpnFOVQoV7YjSsQOB0UzURB90Pl9
'' SIG '' TWh+57ag9I2ziOSXv2MhkJi/E7xX08PhfgjWahQAOPcu
'' SIG '' HjvuzKb2Mln+X2U/4Jvr40ZHBhpVfgsnfsCi9aDg3iI/
'' SIG '' Dv9+lfvzo7oiPhisEeTwmQNtO4V8CdPuXciaC1TjqAlx
'' SIG '' a+DPIhAPdc9xck4Krd9AOly3UeGheRTGTSQjMF287Dxg
'' SIG '' aqwvB8z98OpH2YhQXv1mblZhJymJhFHmgudGUP2UKiyn
'' SIG '' 5HU+upgPhH+fMRTWrdXyZMt7HgXQhBlyF/EXBu89zdZN
'' SIG '' 7wZC/aJTKk+FHcQdPK/P2qwQ9d2srOlW/5MCAwEAAaOC
'' SIG '' Ac4wggHKMB0GA1UdDgQWBBT0tuEgHf4prtLkYaWyoiWy
'' SIG '' yBc1bjAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd
'' SIG '' 823IDzASBgNVHRMBAf8ECDAGAQH/AgEAMA4GA1UdDwEB
'' SIG '' /wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDCDB5Bggr
'' SIG '' BgEFBQcBAQRtMGswJAYIKwYBBQUHMAGGGGh0dHA6Ly9v
'' SIG '' Y3NwLmRpZ2ljZXJ0LmNvbTBDBggrBgEFBQcwAoY3aHR0
'' SIG '' cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNydDCBgQYDVR0fBHoweDA6
'' SIG '' oDigNoY0aHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0Rp
'' SIG '' Z2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDA6oDigNoY0
'' SIG '' aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
'' SIG '' QXNzdXJlZElEUm9vdENBLmNybDBQBgNVHSAESTBHMDgG
'' SIG '' CmCGSAGG/WwAAgQwKjAoBggrBgEFBQcCARYcaHR0cHM6
'' SIG '' Ly93d3cuZGlnaWNlcnQuY29tL0NQUzALBglghkgBhv1s
'' SIG '' BwEwDQYJKoZIhvcNAQELBQADggEBAHGVEulRh1Zpze/d
'' SIG '' 2nyqY3qzeM8GN0CE70uEv8rPAwL9xafDDiBCLK938ysf
'' SIG '' DCFaKrcFNB1qrpn4J6JmvwmqYN92pDqTD/iy0dh8GWLo
'' SIG '' XoIlHsS6HHssIeLWWywUNUMEaLLbdQLgcseY1jxk5R9I
'' SIG '' EBhfiThhTWJGJIdjjJFSLK8pieV4H9YLFKWA1xJHcLN1
'' SIG '' 1ZOFk362kmf7U2GJqPVrlsD0WGkNfMgBsbkodbeZY4Ui
'' SIG '' jGHKeZR+WfyMD+NvtQEmtmyl7odRIeRYYJu6DC0rbaLE
'' SIG '' frvEJStHAgh8Sa4TtuF8QkIoxhhWz0E0tmZdtnR79VYz
'' SIG '' Ii8iNrJLokqV2PWmjlIxggJNMIICSQIBATCBhjByMQsw
'' SIG '' CQYDVQQGEwJVUzEVMBMGA1UEChMMRGlnaUNlcnQgSW5j
'' SIG '' MRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMTEwLwYD
'' SIG '' VQQDEyhEaWdpQ2VydCBTSEEyIEFzc3VyZWQgSUQgVGlt
'' SIG '' ZXN0YW1waW5nIENBAhAEzT+FaK52xhuw/nFgzKdtMA0G
'' SIG '' CWCGSAFlAwQCAQUAoIGYMBoGCSqGSIb3DQEJAzENBgsq
'' SIG '' hkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjAxMDA0
'' SIG '' MDAyMjMyWjArBgsqhkiG9w0BCRACDDEcMBowGDAWBBQD
'' SIG '' Jb1QXtqWMC3CL0+gHkwovig0xTAvBgkqhkiG9w0BCQQx
'' SIG '' IgQg4LLHg3s+MSOHf7gTDu33w5WN83rviGVp3e48cXHz
'' SIG '' PgkwDQYJKoZIhvcNAQEBBQAEggEAin50aWsut+6v2YUP
'' SIG '' PdIceBKYO2FiZnwY8zIcdgbJ3TnL/lKs7QAU7vnMhi9m
'' SIG '' jfmaXkKsQffU8WcAadiqKh3r1g8+RxSM+46KIDaHaKPw
'' SIG '' rcT4rJ47H5U43k7LjzRQAKJQqgHGkA7ObzOmbwFs/jfL
'' SIG '' X+YwMnzrUQnhDOQErLDa6wHkD0W7YMdHwWirR5/k9Rum
'' SIG '' Zl/lGVRof6aM3Pxm8sVPpjQqMODZGT3+X52p7zEFaoWQ
'' SIG '' 6UfmKvMan/zMsf85tvd6xETaIfj8CLt7PdB1wsbv/2gp
'' SIG '' G37xI+H7pfqeeVfFbhdv1ffBtebXf+CC/DVLx8PBisw1
'' SIG '' xovYeDdsfXEefVj/Kg==
'' SIG '' End signature block
